!***************************************************************************************************************************
! Parameters to be shared across the program
!***************************************************************************************************************************
module Parms
  
  logical          :: echo_on                      ! Produce echo information
  character(100)   :: in_path                      ! The pathway to the G-Range files
  character(32)    :: file_name                    ! The name of the file to be processed
  character(100)   :: out_path_root                ! The pathway and root of the files to be produced
  integer          :: start_year                   ! The first year to export
  integer          :: end_year                     ! The last year to export
  integer          :: layers                       ! The number of layers of information to export
  integer          :: year
  integer          :: month
  character(2)     :: month_string
  integer          :: layer
  ! The following are from the Range.gof file
  integer          :: r_cell_cnt
  integer          :: x_dim
  integer          :: y_dim
  integer          :: lower_x
  integer          :: lower_y
  integer          :: upper_x
  integer          :: upper_y
  real             :: rlower_x
  real             :: rlower_y
  real             :: rupper_x
  real             :: rupper_y
  real             :: cell_size
  integer          :: first_year
  integer          :: last_year
  real             :: tglobe(-2160:2160, -1080:1080)  

  type Range_Cells
    integer        :: cell_index
    integer        :: zone
    integer        :: x
    integer        :: y
    integer        :: range_type
  end type
  ! NOTE the following includes a limit, for simplicity.   For more than the given rangeland cells, 
  !      the program will need to be recompiled
  type (Range_Cells)  :: r_cells(200000)  

  
end module