import os.path
import re
import tkinter as tk
import tkinter.messagebox
from tkinter import Listbox
from matplotlib.backends.backend_tkagg import (FigureCanvasTkAgg)  # , NavigationToolbar2Tk)
from matplotlib.figure import Figure
import numpy
from PIL import Image, ImageTk

OUTPUT_FILE_COUNT = 129  # Adjust as needed


def get_path():
    # The *ONE* expectation is that there is a single-line INI file in the same folder that points to G_Range
    f = open("L_RANGE.INI")
    g_path = re.search("'(.*?)'", f.readline()).group(1)  # Parse the substring between delimiters
    f.close()
    return g_path


def get_sim_detail(g_path):
    s_list = []
    f = open(f'{g_path}\\Output\\Rng_Data.gof', 'r')
    lst = f.readline().split()
    s_list.append(int(lst[0]))  # Total cells simulated
    s_list.append(int(lst[1]))  # X ... cells across ... columns
    s_list.append(int(lst[2]))  # Y ... cells up-and-down ... rows
    s_list.append(float(lst[3]))  # Minimum X
    s_list.append(float(lst[4]))  # Minimum Y
    s_list.append(float(lst[5]))  # Maximum X
    s_list.append(float(lst[6]))  # Maximum Y
    s_list.append(float(lst[7]))  # Cell size
    s_list.append(int(lst[8]))  # Start year
    s_list.append(int(lst[9]))  # End year
    # Appending g_path to avoid constant passing or global
    s_list.append(g_path)  # GRange_Path
    f.close()
    return s_list


def get_cell_detail(g_path):
    cell_data: list[int] = []
    f = open(f'{g_path}\\Output\\Rng_Data.gof', 'r')
    _ = f.readline()  # Discard simulation data processed earlier
    a = True
    while a:
        ln = f.readline()
        if not ln:
            a = False
        else:
            lst = ln.split(",")
            cell_data.append(int(lst[1]))  # Zone ID
            cell_data.append(int(lst[2]))  # X
            cell_data.append(int(lst[3]))  # Y
            cell_data.append(int(lst[4]))  # Landscape unit
            cell_data.append(int(lst[0]))  # The sequential number of rangeland cells in the database
    f.close()
    return cell_data


def get_output_list(g_path):
    # Make this more flexible, for additional output files (or fewer) another time.  For now, 127 entries.
    o_list: list[str] = []
    f = open(f'{g_path}\\Parms\\Output_List.grg', 'r')
    j = 0
    for i in range(OUTPUT_FILE_COUNT):
        ln = f.readline()
        if ln[0:1] == "1":
            o_list.append(ln[0:1])  # 0 - To use or not use the output file
            o_list.append(ln[4:37])  # 1 - Output file name
            var_list.insert(j, ln[4:37])  # Add the entry to the listbox
            o_list.append(ln[40:41])  # 2 - Layers in output file
            o_list.append(ln[44:54])  # 3 - Type of layers
            o_list.append(ln[58:77])  # 4 - Units of data
            o_list.append(ln[82:191])  # 5 - Longer description of output
            j = j + 1
    return o_list


def var_selected(event):
    stats_panel.config(text="")
    map_canvas.delete("all")
    layer_list.delete(0, "end")
    w = event.widget
    value = w.curselection()
    value = value[0]
    j = (value * 6) + 2  # Convert the choice to an entry, skipping
    layers = int(output_list[j])
    layer_type = output_list[j + 1].strip()
    plot_canvas.get_tk_widget().pack_forget()
    if layers <= 1:
        resize_canvas()
    else:
        for i in range(layers):
            j = str(i + 1)
            layer_list.insert(i, f"{layer_type} {j}")


def layer_selected(event):
    _ = event
    plot_canvas.get_tk_widget().pack_forget()
    resize_canvas()


def year_update_value(event):
    _ = event
    resize_canvas()


def month_update_value(event):
    _ = event
    resize_canvas()


def resize_canvas():
    """

    :rtype: object
    """
    # Assuming here that the canvas is updated to its final size. That isn't the case at all points in a program.
    global map_image  # Other (better) solutions to this 'bug' online (e.g., self)
    # Also, no resize is available for PhotoImage (a Zoom and subset is, but it is integer scaling
    # only and not appropriate).  So some extra steps, from PhotoImage to Image to Resize and
    # back to PhotoImage for use in Canvas.
    map_data = fill_array()
    map_array = map_to_colors(map_data)
    pre_photo_image = ImageTk.PhotoImage(image=Image.fromarray(map_array.astype('uint8')).convert('RGBA'))
    pre_image = ImageTk.getimage(pre_photo_image)

    xt = map_canvas.winfo_width()
    yt = map_canvas.winfo_height()
    xy_rat = xt / yt
    map_rat = sim_list[1] / sim_list[2]
    if xy_rat < map_rat:  # Taller than needed.   X limits the resize, and extra space in Y if needed
        y2 = int(xt * (1.0 / map_rat))
        pre_image = pre_image.resize((xt, y2), Image.LANCZOS)
    else:  # Wider than needed.    Y limits the resize
        x2 = int(yt * map_rat)
        pre_image = pre_image.resize((x2, yt), Image.LANCZOS)
    map_image = ImageTk.PhotoImage(image=pre_image)
    map_canvas.create_image(xt / 2, yt / 2, image=map_image)


# def root_resize(event):
#     print("Root resize disabled")
#     resize_canvas()


def frame_resized(event):
    _ = event
    # Determine if entries are selected in the variable and (perhaps) listboxes.  If so, call resize.
    v2 = 0
    v = var_list.curselection()
    if len(v) > 0:
        v2 = v[0]
    lyr = layer_list.curselection()
    if v2 > 0 and (len(lyr) == 0 or lyr[0] > 0):  # If there is a var select and either no layers or one is selected
        resize_canvas()


def fill_array():
    bytes_per_record = 4
    v = var_list.curselection()
    v_selected = v[0] * 6
    g_range = sim_list[10]
    f = output_list[(v_selected + 1)].strip()
    f_name = f"{g_range}\\Output\\{f}.gof"
    print("Using file: ", f_name)
    start_year = sim_list[8]  # Putting these variables in place for clarity and error-checking
    if layer_list.size() > 0:
        l_selected = layer_list.curselection()
        l_selected = l_selected[0]
    else:
        l_selected = 0
    range_cells = sim_list[0]
    pre_years = year_slider.get() - start_year
    pre_months = month_slider.get() - 1
    layer_count = layer_list.size()
    if layer_count == 0:
        layer_count = 1
    #    print("PRE YEARS MONTHS LAYERS:  ", pre_years, pre_months, layer_selected, "   COUNT:   ", layer_count)
    pre_image_count = pre_years * 12 * layer_count * (range_cells + 3)  # Years
    #    print("PRE IMAGE COUNT 1: ", pre_image_count)
    pre_image_count = pre_image_count + pre_months * layer_count * (range_cells + 3)  # Months
    #    print("PRE IMAGE COUNT 1: ", pre_image_count)
    pre_image_count = pre_image_count + l_selected * (range_cells + 3)  # Layers
    #    print("PRE IMAGE COUNT 1: ", pre_image_count)
    bytes_to_skip = pre_image_count * bytes_per_record

    f = open(f_name, 'rb')
    # Data are 4 byte longs in VB tool.  FLOAT32 in NumPy brings the data in as 4 bytes
    # The following SHOULD read the number of cells simulated, year, and month
    cells_date = numpy.fromfile(f, dtype=numpy.float32, count=3, sep='', offset=bytes_to_skip)
    rng_check = int(cells_date[0])
    if rng_check != range_cells:
        tk.messagebox.showerror("Sync error", "The number of cells simulated doesn't match what is expected.")
        print(f"The interface expects {range_cells} to be simulated, but read {rng_check} cells.")
    yr_check = int(cells_date[1])
    mn_check = int(cells_date[2])
    yr_slider = year_slider.get()
    mn_slider = month_slider.get()
    print("YR_CHK  MN_CHK   YR_SLIDE   MN_SLIDE:  ", yr_check, mn_check, yr_slider, mn_slider)
    if yr_check != yr_slider or mn_check != mn_slider:
        tk.messagebox.showerror("Sync error", "The year or month are out of sync.")
        print(f"The interface expects year {year.slider.get()} and month {month_slider.get()}.")
        print(f"Instead, it read in from the file year {yr_check} and month {mn_check}.")
    map_data = numpy.fromfile(f, dtype=numpy.float32, count=range_cells, sep='',
                              offset=0)  # offset from CURRENT position, which is after the three
    # Only values are stored, so G-Range assumes the 1->N values map directly to 1->N cells in Rng_Data.gof
    f.close()
    return map_data


def map_to_colors(m_data):
    global cell_list  # THIS SHOULD BE IN A CLASS I BELIEVE - TRY THAT LATER
    low_val = numpy.mean(m_data[m_data > 0]) - (2.0 * numpy.std(m_data[m_data > 0]))
    # Note, dropping negative value not suitable for very cold regions for temperature only.  Graphs will remain ok
    if numpy.isnan(low_val):
        low_val = 0
    if low_val < numpy.amin(m_data):  # If the MN - (SD*2) rule yields a too small value
        low_val = numpy.amin(m_data)
    if low_val < 0:
        low_val = 0
    high_val = numpy.mean(m_data[m_data > 0]) + (2.0 * numpy.std(m_data[m_data > 0]))
    if numpy.isnan(high_val):
        high_val = 0
    if high_val > numpy.amax(m_data):  # If the MN + (SD*2) rule yields a too large value
        high_val = numpy.amax(m_data)

    xdim = sim_list[1] + 1
    ydim = sim_list[2] + 1
    map_array = numpy.zeros((ydim, xdim, 3), dtype=int)
    print(m_data)
    for i in range(len(m_data)):
        offset = int(i) * 5 + 1
        xt = cell_list[offset]
        yt = cell_list[offset + 1]
        if (high_val - low_val) != 0:
            clr = int((m_data[i] - low_val) / (high_val - low_val) * 255)  # Stretch the data
            if clr > 255:
                clr = 255
            if clr < 0:
                clr = 0
        else:
            clr = 0
        map_array[yt, xt, 2] = 255 - clr
        map_array[yt, xt, 0] = clr
        map_array[yt, xt, 1] = clr
    update_statistics()
    return map_array


def rgb_to_hex(r, g, b):
    return "{:X}{:X}{:X}".format(r, g, b)


def map_button_pressed(event):
    # Can't tell where on the continent is being clicked easily.  But the image dimensions and canvas dimensions,
    # plus the placement of the image on the canvas, are all known, so an algebraic exercise to get the location.

    # TEST TEST TEST  TEST

    if layer_list.size() > 0 and len(layer_list.curselection()) == 0:
        return
    x_edge_correction = 0.0  # The matrix is a little smaller than the image.
    y_edge_correction = 0.0  # This correction should trim away the black edges in the logic.
    map_width = map_image.width()
    map_height = map_image.height()
    canvas_width = map_canvas.winfo_width()
    canvas_height = map_canvas.winfo_height()
    matrix_width = sim_list[1]
    matrix_height = sim_list[2]
    print("Inputs, X, Y, Map W, Map H, Canvas W, Canvas H, Matrix W, Matrix H: ")
    print(event.x, event.y, map_width, map_height, canvas_width, canvas_height, matrix_width, matrix_height)
    left_edge = canvas_width / 2.0 - (map_width / 2.0)
    top_edge = canvas_height / 2.0 - (map_height / 2.0)

    if left_edge < event.x < (left_edge + map_width):  # Get matrix cell value
        if top_edge < event.y < (top_edge + map_height):
            ix = ((event.x - left_edge) - (map_width * x_edge_correction))  # Canvas units
            ix = int(ix * (matrix_width / map_width))  # Map units
            iy = ((event.y - top_edge) - (map_height * y_edge_correction))  # Canvas units
            iy = int(iy * (matrix_height / map_height))  # Map units
            map_canvas.create_rectangle(event.x - 2, event.y - 2, event.x + 2, event.y + 2, fill="red")
            graph_response(ix, iy)


def graph_response(ix, iy):
    global cell_list  # THIS SHOULD BE IN A CLASS I BELIEVE - TRY THAT LATER
    fig.clf()
    ax = fig.add_subplot()
    # Axes
    ax.set_xlabel("Time (months)")
    v = var_list.curselection()
    v_selected = v[0] * 6
    ax.set_ylabel(output_list[(v_selected + 4)].strip())
    # Get data.  Going to open the file each time, for clarity.
    start_year = sim_list[8]
    total_months = ((sim_list[9] - start_year) + 1) * 12
    t = numpy.zeros(total_months)
    bytes_per_record = 4
    v = var_list.curselection()
    v_selected = v[0] * 6
    g_range = sim_list[10]
    if layer_list.size() > 0:
        l_selected = layer_list.curselection()
        l_selected = l_selected[0]
    else:
        l_selected = 0
    range_cells = sim_list[0]
    layer_count = layer_list.size()
    if layer_count != 0:
        pass
    else:
        layer_count = 1
    # Find the entry in the rangeland data
    i = 0
    offset_x = i
    offset_y = offset_x + 1
    rng_num = 0
    print("PRE PRE PRE FINDING IX AND IY:  ", ix, iy, cell_list[offset_x], cell_list[offset_y + 1])
    while ix != cell_list[offset_x] or iy != cell_list[offset_y]:
        #  print("FINDING IX AND IY:  ", ix, iy, cell_list[offset_x], cell_list[offset_y], rng_num)
        i = i + 1
        offset_x = int(i) * 5 + 1
        offset_y = offset_x + 1
        rng_num = cell_list[offset_y + 2]
    for current_month in range(total_months):
        f: str = output_list[(v_selected + 1)].strip()
        f_name = f"{g_range}\\Output\\{f}.gof"
        pre_cell_count = current_month * layer_count * (range_cells + 3)  # All previous images (or months)
        pre_cell_count = pre_cell_count + (l_selected * (range_cells + 3))  # Previous layers in current month
        pre_cell_count = pre_cell_count + rng_num + 3  # Previous pixels in the image
        bytes_to_skip = pre_cell_count * bytes_per_record

        f_file = open(f_name, 'rb')
        t[current_month] = numpy.fromfile(f_file, dtype=numpy.float32, count=1, sep='', offset=bytes_to_skip)
        f_file.close()
    _ = ax.plot(numpy.arange(0, total_months), t)
    plot_canvas.draw()
    plot_canvas.get_tk_widget().pack(side=tkinter.BOTTOM, fill=tkinter.BOTH, expand=True)


def update_statistics():
    v = var_list.curselection()
    v_selected = v[0] * 6
    stat_report = output_list[(v_selected + 5)].strip()
    stat_report = stat_report + " (" + output_list[(v_selected + 4)].strip() + ")"
    if layer_list.size() > 0:
        stat_report = stat_report + ", with " + output_list[(v_selected + 2)].strip()
        stat_report = stat_report + " " + output_list[(v_selected + 3)].strip().lower() + "s"
    stats_panel.config(text=stat_report)


grange_path = ""

root = tk.Tk()
root.geometry("850x1032")
root.title("Af-Range Viewer")
# root.bind("<Configure>", root_resize)
frame = tk.Frame(root)
root.rowconfigure(0, weight=1)
root.columnconfigure(0, weight=1)
frame.grid(row=0, column=0, sticky="news")
frame.rowconfigure(0, weight=90)  # 40
frame.rowconfigure(1, weight=20)  # 30
frame.rowconfigure(2, weight=0)  # 0
frame.rowconfigure(3, weight=5)  # 25
frame.columnconfigure(0, weight=1)
frame.columnconfigure(1, weight=3)
frame.bind('<Configure>', frame_resized)

var_list: Listbox = tk.Listbox(frame, activestyle="none", selectmode="single", exportselection=False)
var_list.grid(column=0, row=0, sticky="news", padx=8, pady=8)
var_scroll = tk.Scrollbar(var_list)
var_scroll.pack(side="right", fill="both")
var_list.config(yscrollcommand=var_scroll.set)
var_scroll.config(command=var_list.yview)
var_list.bind('<<ListboxSelect>>', var_selected)

layer_list = tk.Listbox(frame, activestyle="none", selectmode="single", exportselection=False)
layer_list.grid(column=0, row=1, sticky="news", padx=8, pady=8)
layer_scroll = tk.Scrollbar(layer_list)
layer_scroll.pack(side="right", fill="both")
layer_list.config(yscrollcommand=layer_scroll.set)
layer_scroll.config(command=layer_list.yview)
layer_list.bind('<<ListboxSelect>>', layer_selected)

month_panel = tk.Label(frame, text="Months")
month_panel.grid(column=0, row=2, sticky="news")

stats_panel = tk.Label(frame, text="Statistics", anchor="w", padx=5)
stats_panel.grid(column=0, row=3, columnspan=2, sticky="news")

map_canvas = tk.Canvas(frame, bg="grey95")
map_canvas.grid(column=1, row=0, sticky="news")

plot_panel = tk.Canvas(frame, bg="white")
plot_panel.grid(column=1, row=1, rowspan=2, sticky="news")

x = plot_panel.winfo_width()
y = plot_panel.winfo_height()
fig = Figure(figsize=(x, y), dpi=100)
fig.subplots_adjust(bottom=0.25)
plot_canvas = FigureCanvasTkAgg(fig, master=plot_panel)
plot_canvas.draw()
plot_canvas.get_tk_widget().pack(side=tkinter.BOTTOM, fill=tkinter.BOTH, expand=True)
map_canvas.bind("<Button-1>", lambda event, canvas=plot_canvas: map_button_pressed(event))

if __name__ == '__main__':
    grange_path = get_path()
    if not os.path.isdir(grange_path):
        raise Exception(f"The pathway {grange_path} does not exist.  Stopping.")
    print("The pathway to the G-Range application is: " + grange_path)
    output_list: list[str] = get_output_list(grange_path)
    sim_list = get_sim_detail(grange_path)
    year_slider = tk.Scale(month_panel, from_=sim_list[8], to=sim_list[9], orient="horizontal", label="Year")
    year_slider.bind("<ButtonRelease-1>", year_update_value)
    year_slider.pack(fill="x", side="top")
    month_slider = tk.Scale(month_panel, from_=1, to=12, orient="horizontal", label="Month")
    month_slider.bind("<ButtonRelease-1>", month_update_value)
    month_slider.pack(fill="x", side="top")
    cell_list: list[int] = get_cell_detail(grange_path)
    root.mainloop()
